/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.block;

import com.tristankechlo.livingthings.entity.OstrichEntity;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OstrichNestBlock
extends Block
implements ILexiconEntry {
    public static final BooleanProperty EGG = BooleanProperty.m_61465_((String)"egg");
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    private static final VoxelShape EMPTY_NEST_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape FULL_NEST_SHAPE = Shapes.m_83113_((VoxelShape)EMPTY_NEST_SHAPE, (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);

    public OstrichNestBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60918_(SoundType.f_56740_).m_278166_(PushReaction.DESTROY).m_60978_(0.5f).m_60977_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGG, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EGG, HATCH});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21205_();
        boolean hasEgg = (Boolean)state.m_61143_((Property)EGG);
        if (player.m_21205_().m_41720_() == ModItems.LEXICON.get()) {
            return InteractionResult.PASS;
        }
        if (hasEgg && stack.m_41619_()) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)EGG, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)), 2);
            world.m_5594_(player, pos, ModSounds.OSTRICH_EGG_REMOVED.get(), SoundSource.BLOCKS, 0.7f, 0.9f);
            if (!world.f_46443_) {
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)ModItems.OSTRICH_EGG.get()));
                itemEntity.m_32060_();
                world.m_7967_((Entity)itemEntity);
            }
            return InteractionResult.SUCCESS;
        }
        if (!hasEgg && stack.m_150930_(ModItems.OSTRICH_EGG.get())) {
            state = (BlockState)((BlockState)state.m_61124_((Property)EGG, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0));
            world.m_7731_(pos, state, 2);
            world.m_5594_(player, pos, SoundEvents.f_12456_, SoundSource.BLOCKS, 0.7f, 0.9f);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, handIn, hit);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)EGG)).booleanValue()) {
            return;
        }
        if (this.canGrow((Level)worldIn)) {
            int i = (Integer)state.m_61143_((Property)HATCH);
            if (i < 2) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
                worldIn.m_5594_(null, pos, ModSounds.OSTRICH_EGG_CRACKS.get(), SoundSource.BLOCKS, 0.7f, 0.9f);
            } else {
                worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)EGG, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)), 2);
                worldIn.m_5594_(null, pos, ModSounds.OSTRICH_EGG_CRACKS.get(), SoundSource.BLOCKS, 0.7f, 0.9f);
                OstrichEntity ostrichEntity = (OstrichEntity)ModEntityTypes.OSTRICH.get().m_20615_((Level)worldIn);
                ostrichEntity.m_146762_(-24000);
                ostrichEntity.m_20343_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                worldIn.m_7967_((Entity)ostrichEntity);
            }
        }
    }

    private boolean canGrow(Level world) {
        float f = world.m_46942_(1.0f);
        if (f < 0.7f && f > 0.6f) {
            return true;
        }
        return world.f_46441_.m_188503_(175) == 0;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)EGG) != false ? FULL_NEST_SHAPE : EMPTY_NEST_SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.OSTRICH_NEST_BLOCK;
    }
}

